//
// AHKUniqueNumberFormatter.m
// AH-K3001V Utilities
// Modified by FUJIDANA on Tue Mar 22 2005.
// License of referred source code is as following:
//
//
//  MemoryNumberFormatter.m
//  BookmarkUtility
//
//  Created by raktajino on Fri Jul 09 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "AHKUniqueNumberFormatter.h"
#import "AHKUniquelyNumberedArrayController.h"

@implementation AHKUniqueNumberFormatter

#pragma mark init and dealloc
- (id)initWithUniquelyNumberedArrayController:(AHKUniquelyNumberedArrayController *)anArrayController
{
    self = [super init];
    if(self) {
		arrayController = [anArrayController retain];
		[self setAllowsFloats:NO];
		[self setFormat:@"#;0;-#"];
		
		NSDecimal minDecimal = [[NSNumber numberWithInt:[arrayController minValue]] decimalValue];
		NSDecimal maxDecimal = [[NSNumber numberWithInt:[arrayController maxValue]] decimalValue];
		
		[self setMinimum:[NSDecimalNumber decimalNumberWithDecimal:minDecimal]];
		[self setMaximum:[NSDecimalNumber decimalNumberWithDecimal:maxDecimal]];
    }
    return self;
}

- (void)dealloc
{
	[arrayController release];
	arrayController = nil;
	
	[super dealloc];
}

#pragma mark override
- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error
{
	if ([super getObjectValue:obj forString:string errorDescription:error]) {
		unsigned int row = [arrayController selectionIndex];
		if (row != NSNotFound) {
			id currentObject = [[arrayController arrangedObjects] objectAtIndex:row];
			if ([arrayController containsNumber:[string intValue] exceptObject:currentObject] == NO) {
				return YES;
			} else if (error) {
				*error = NSLocalizedString(@"The same memory number has been used.", @"AHKExclusiveNumberFomatter.error.existsSameNumber");
			}
		}
	}
	return NO;
}

@end
